
#define ESCI0_SCISR1_full	(*(vuint32_t  *)(0xFFFB0008))	/* SCISR1 - Status Register 1 */

/* ESCI Module (ESCI)*/
#define ESCI0_SCIBD	(*(vuint16_t *)(0xFFFB0000))	/* SCIBD - Baud Rate Register */
#define ESCI0_SCICR1	(*(vuint8_t  *)(0xFFFB0002))	/* SCICR1 - Control Register 1 */
#define ESCI0_SCICR2	(*(vuint8_t  *)(0xFFFB0003))	/* SCICR2 - Control Register 2 */
#define ESCI0_SCICR3	(*(vuint8_t  *)(0xFFFB0004))	/* SCICR3 - Control Register 3 */
#define ESCI0_SCICR4	(*(vuint8_t  *)(0xFFFB0005))	/* SCICR4 - Control Register 4 */
#define ESCI0_SCIDRH	(*(vuint8_t  *)(0xFFFB0006))	/* SCIDRH - Data Register High */
#define ESCI0_SCIDRL	(*(vuint8_t  *)(0xFFFB0007))	/* SCIDRL - Data Register Low */
#define ESCI0_SCISR1	(*(vuint8_t  *)(0xFFFB0008))	/* SCISR1 - Status Register 1 */
#define ESCI0_SCISR2	(*(vuint8_t  *)(0xFFFB0009))	/* SCISR2 - Status Register 2 */
#define ESCI0_LINSTAT1	(*(vuint8_t  *)(0xFFFB000A))	/* LINSTAT1 - LIN Status Register 1 */
#define ESCI0_LINSTAT2	(*(vuint8_t  *)(0xFFFB000B))	/* LINSTAT2 - LIN Status Register 2 */
#define ESCI0_LINCTRL1	(*(vuint8_t  *)(0xFFFB000C))	/* LINCTRL1 - LIN Control Register 1 */
#define ESCI0_LINCTRL2	(*(vuint8_t  *)(0xFFFB000D))	/* LINCTRL2 - LIN Control Register 2 */
#define ESCI0_LINCTRL3	(*(vuint8_t  *)(0xFFFB000E))	/* LINCTRL3 - LIN Control Register 3 */
#define ESCI0_LINTX	(*(vuint8_t  *)(0xFFFB0010))	/* LINTX - LIN TX Register */
#define ESCI0_LINRX	(*(vuint8_t  *)(0xFFFB0014))	/* LINRX - LIN RX Register */
#define ESCI0_LINCRCP1	(*(vuint8_t  *)(0xFFFB0018))	/* LINCRCP1 - LIN CRC Polynomial Register 1 */
#define ESCI0_LINCRCP2	(*(vuint8_t  *)(0xFFFB0019))	/* LINCRCP2 - LIN CRC Polynomial Register 2 */
#define ESCI1_SCIBD	(*(vuint16_t *)(0xFFFB4000))	/* SCIBD - Baud Rate Register */
#define ESCI1_SCICR1	(*(vuint8_t  *)(0xFFFB4002))	/* SCICR1 - Control Register 1 */
#define ESCI1_SCICR2	(*(vuint8_t  *)(0xFFFB4003))	/* SCICR2 - Control Register 2 */
#define ESCI1_SCICR3	(*(vuint8_t  *)(0xFFFB4004))	/* SCICR3 - Control Register 3 */
#define ESCI1_SCICR4	(*(vuint8_t  *)(0xFFFB4005))	/* SCICR4 - Control Register 4 */
#define ESCI1_SCIDRH	(*(vuint8_t  *)(0xFFFB4006))	/* SCIDRH - Data Register High */
#define ESCI1_SCIDRL	(*(vuint8_t  *)(0xFFFB4007))	/* SCIDRL - Data Register Low */
#define ESCI1_SCISR1	(*(vuint8_t  *)(0xFFFB4008))	/* SCISR1 - Status Register 1 */
#define ESCI1_SCISR2	(*(vuint8_t  *)(0xFFFB4009))	/* SCISR2 - Status Register 2 */
#define ESCI1_LINSTAT1	(*(vuint8_t  *)(0xFFFB400A))	/* LINSTAT1 - LIN Status Register 1 */
#define ESCI1_LINSTAT2	(*(vuint8_t  *)(0xFFFB400B))	/* LINSTAT2 - LIN Status Register 2 */
#define ESCI1_LINCTRL1	(*(vuint8_t  *)(0xFFFB400C))	/* LINCTRL1 - LIN Control Register 1 */
#define ESCI1_LINCTRL2	(*(vuint8_t  *)(0xFFFB400D))	/* LINCTRL2 - LIN Control Register 2 */
#define ESCI1_LINCTRL3	(*(vuint8_t  *)(0xFFFB400E))	/* LINCTRL3 - LIN Control Register 3 */
#define ESCI1_LINTX	(*(vuint8_t  *)(0xFFFB4010))	/* LINTX - LIN TX Register */
#define ESCI1_LINRX	(*(vuint8_t  *)(0xFFFB4014))	/* LINRX - LIN RX Register */
#define ESCI1_LINCRCP1	(*(vuint8_t  *)(0xFFFB4018))	/* LINCRCP1 - LIN CRC Polynomial Register 1 */
#define ESCI1_LINCRCP2	(*(vuint8_t  *)(0xFFFB4019))	/* LINCRCP2 - LIN CRC Polynomial Register 2 */
#define ESCI_SCIBD(x)	(*(vuint16_t *)(0xFFFB0000+((x)*0x4000)))	/* SCIBD - Baud Rate Register */
#define ESCI_SCICR1(x)	(*(vuint8_t  *)(0xFFFB0002+((x)*0x4000)))	/* SCICR1 - Control Register 1 */
#define ESCI_SCICR2(x)	(*(vuint8_t  *)(0xFFFB0003+((x)*0x4000)))	/* SCICR2 - Control Register 2 */
#define ESCI_SCICR3(x)	(*(vuint8_t  *)(0xFFFB0004+((x)*0x4000)))	/* SCICR3 - Control Register 3 */
#define ESCI_SCICR4(x)	(*(vuint8_t  *)(0xFFFB0005+((x)*0x4000)))	/* SCICR4 - Control Register 4 */
#define ESCI_SCIDRH(x)	(*(vuint8_t  *)(0xFFFB0006+((x)*0x4000)))	/* SCIDRH - Data Register High */
#define ESCI_SCIDRL(x)	(*(vuint8_t  *)(0xFFFB0007+((x)*0x4000)))	/* SCIDRL - Data Register Low */
#define ESCI_SCISR1(x)	(*(vuint8_t  *)(0xFFFB0008+((x)*0x4000)))	/* SCISR1 - Status Register 1 */
#define ESCI_SCISR2(x)	(*(vuint8_t  *)(0xFFFB0009+((x)*0x4000)))	/* SCISR2 - Status Register 2 */
#define ESCI_LINSTAT1(x)	(*(vuint8_t  *)(0xFFFB000A+((x)*0x4000)))	/* LINSTAT1 - LIN Status Register 1 */
#define ESCI_LINSTAT2(x)	(*(vuint8_t  *)(0xFFFB000B+((x)*0x4000)))	/* LINSTAT2 - LIN Status Register 2 */
#define ESCI_LINCTRL1(x)	(*(vuint8_t  *)(0xFFFB000C+((x)*0x4000)))	/* LINCTRL1 - LIN Control Register 1 */
#define ESCI_LINCTRL2(x)	(*(vuint8_t  *)(0xFFFB000D+((x)*0x4000)))	/* LINCTRL2 - LIN Control Register 2 */
#define ESCI_LINCTRL3(x)	(*(vuint8_t  *)(0xFFFB000E+((x)*0x4000)))	/* LINCTRL3 - LIN Control Register 3 */
#define ESCI_LINTX(x)	(*(vuint8_t  *)(0xFFFB0010+((x)*0x4000)))	/* LINTX - LIN TX Register */
#define ESCI_LINRX(x)	(*(vuint8_t  *)(0xFFFB0014+((x)*0x4000)))	/* LINRX - LIN RX Register */
#define ESCI_LINCRCP1(x)	(*(vuint8_t  *)(0xFFFB0018+((x)*0x4000)))	/* LINCRCP1 - LIN CRC Polynomial Register 1 */
#define ESCI_LINCRCP2(x)	(*(vuint8_t  *)(0xFFFB0019+((x)*0x4000)))	/* LINCRCP2 - LIN CRC Polynomial Register 2 */
/* Bit definitions and macros for ESCI_SCIBD */
#define ESCI_SBR(x)	(((x)&0x1FFF)<<0)	/* SCI Baud Rate Bits */
/* Bit definitions and macros for ESCI_SCICR1 */
#define ESCI_PT	(0x01)	/*	Parity Type */
#define ESCI_PE	(0x02)	/*	Parity Enable */
#define ESCI_ILT	(0x04)	/*	Idle Line Type */
#define ESCI_WAKE	(0x08)	/*	Wakeup Condition */
#define ESCI_M	(0x10)	/*	Data Format Mode */
#define ESCI_RSRC	(0x20)	/*	Receiver Source */
#define ESCI_SCISDOZ	(0x40)	/*	SCI Stop in Doze Mode */
#define ESCI_LOOPS	(0x80)	/*	Loop Select */
/* Bit definitions and macros for ESCI_SCICR2 */
#define ESCI_SBK	(0x01)	/*	Send Break */
#define ESCI_RWU	(0x02)	/*	Receiver Wakeup */
#define ESCI_RE	(0x04)	/*	Receiver Enable */
#define ESCI_TE	(0x08)	/*	Transmitter Enable */
#define ESCI_ILIE	(0x10)	/*	Idle Line Interrupt Enable */
#define ESCI_RIE	(0x20)	/*	Receiver Full Interrupt Enable */
#define ESCI_TCIE	(0x40)	/*	Transmission Complete Interrupt Enable */
#define ESCI_TIE	(0x80)	/*	Transmitter Interrupt Enable */
/* Bit definitions and macros for ESCI_SCICR3 */
#define ESCI_TXDIR	(0x01)	/*	Transmitter pin data direction */
#define ESCI_BRK13	(0x02)	/*	Break Transmit character length */
#define ESCI_TXDMA	(0x04)	/*	Activate TX DMA channel */
#define ESCI_RXDMA	(0x08)	/*	Activate RX DMA channel */
#define ESCI_IEBERR	(0x10)	/*	Enable Bit Error Interrupt */
#define ESCI_BSTP	(0x20)	/*	Bit Error / Physical Bus Error Stop */
#define ESCI_FBR	(0x40)	/*	Fast Bit Error */
#define ESCI_MDIS	(0x80)	/*	Module Disable */
/* Bit definitions and macros for ESCI_SCICR4 */
#define ESCI_PFIE	(0x01)	/* Parity Flag Interrupt Enable	*/
#define ESCI_FEIE	(0x02)	/* Frame Error Interrupt Enable	*/
#define ESCI_NFIE	(0x04)	/* Noise Flag Interrupt Enable	*/
#define ESCI_ORIE	(0x08)	/* Overrun Error Interrupt Enable	*/
#define ESCI_PMSK	(0x10)	/* Parity Mask	*/
#define ESCI_SBSTP	(0x40)	/* SCI Bit Error Stop	*/
#define ESCI_BESM13	(0x80)	/* Bit Error Sample Mode, Bit 13 */
/* Bit definitions and macros for ESCI_SCIDRH */
#define ESCI_T8	(0x40)	/*	Transmit Bit 8 */
#define ESCI_R8	(0x80)	/*	Received Bit 8 */
/* Bit definitions and macros for ESCI_SCIDRL */
#define ESCI_T_R(x)	(((x)&0xFF)<<0)	/*	RX/TX bits seven through zero */
/* Bit definitions and macros for ESCI_SCISR1 */
#define ESCI_PF	(0x01)	/*	Parity Error Flag */
#define ESCI_FE	(0x02)	/*	Framing Error Flag */
#define ESCI_NF	(0x04)	/*	Noise Flag */
#define ESCI_OR	(0x08)	/*	Overrun Flag */
#define ESCI_IDLE	(0x10)	/*	Idle Line Flag */
#define ESCI_RDRF	(0x20)	/*	Receive Data Register Full Flag */
#define ESCI_TC	(0x40)	/*	Transmit Complete Flag */
#define ESCI_TDRE	(0x80)	/*	Transmit Data Register Empty Flag */
/* Bit definitions and macros for ESCI_SCISR2 */
#define ESCI_RAF	(0x01)	/*	Receiver Active Flag */
#define ESCI_BERR	(0x10)	/*	Bit Error */
/* Bit definitions and macros for ESCI_LINSTAT1 */
#define ESCI_FRC	(0x01)	/*	Frame Complete */
#define ESCI_CKERR	(0x02)	/*	Checksum Error */
#define ESCI_CERR	(0x04)	/*	CRC Error */
#define ESCI_PBERR	(0x08)	/*	Physical Bus Error */
#define ESCI_STO	(0x10)	/*	Slave TimeOut */
#define ESCI_LWAKE	(0x20)	/*	Received LIN Wakeup Signal */
#define ESCI_TXRDY	(0x40)	/*	Transmit Data Ready */
#define ESCI_RXRDY	(0x80)	/*	Receive Data Ready */
/* Bit definitions and macros for ESCI_LINSTAT2 */
#define ESCI_OVFL	(0x01)	/*	RX Register Overflow */
#define ESCI_UREQ	(0x02)	/*	Unrequested Data on LIN Bus */
/* Bit definitions and macros for ESCI_LINCTRL1 */
#define ESCI_LIN	(0x01)	/*	LIN Mode */
#define ESCI_PRTY	(0x02)	/*	Activating Parity Generation */
#define ESCI_DSF	(0x04)	/*	Double Stop Flags */
#define ESCI_LDBG	(0x08)	/*	LIN Debug Mode */
#define ESCI_WUD(x)	(((x)&0x03)<<4)	/*	WakeUp Delimiter Time */
#define ESCI_WU	(0x40)	/*	LIN Bus WakeUp */
#define ESCI_LRES	(0x80)	/*	LIN Resync */
/* Bit definitions and macros for ESCI_LINCTRL2 */
#define ESCI_FCIE	(0x01)	/*	Frame Complete Interrupt Enable */
#define ESCI_CKIE	(0x02)	/*	Checksum Error Interrupt Enable */
#define ESCI_CIE	(0x04)	/*	CRC Error Interrupt Enable */
#define ESCI_PBIE	(0x08)	/*	Physical Bus Error Interrupt Enable */
#define ESCI_STIE	(0x10)	/*	Slave Timeout Error Interrupt Enable */
#define ESCI_WUIE	(0x20)	/*	RX WakeUP Interrupt Enable */
#define ESCI_TXIE	(0x40)	/*	LIN TXREG Ready Interrupt Enable */
#define ESCI_RXIE	(0x80)	/*	LIN RXREG Ready Interrupt Enable */
/* Bit definitions and macros for ESCI_LINCTRL3 */
#define ESCI_OFIE	(0x01)	/*	Overflow Interrupt Enable */
#define ESCI_UQIE	(0x02)	/*	Unrequested Data Interrupt Enable */
/* Bit definitions and macros for ESCI_LINTX */
#define ESCI_P1	(0x80)
#define ESCI_P0	(0x40)
#define ESCI_ID5	(0x20)
#define ESCI_ID4	(0x10)
#define ESCI_ID3	(0x08)
#define ESCI_ID2	(0x04)
#define ESCI_ID1	(0x02)
#define ESCI_ID0	(0x01)
#define ESCI_HDCHK	(0x80)
#define ESCI_CSUM	(0x40)
#define ESCI_CRC	(0x20)
#define ESCI_TX	(0x10)
